# backend-agenter

## Table of contents
<details open="open">
  <summary>Contents</summary>
  <ol>
    <li>
      <a href="#about-the-project">About project</a>
      <ol>
        <li><a href="#stack">Stack</a></li>
        <li><a href="#note">Note</a></li>
      </ol>
    </li>
    <li><a href="#running">Running</a></li>
    <ol>
        <li><a href="#envs">Envs</a></li>
        <li><a href="#configs">Configs</a></li>
        <li><a href="#image-build">Image-build</a></li>
        <li><a href="#deploy">Deploy</a></li>
    </ol>
    <li><a href="#maintainers">Maintainers</a></li>
  </ol>
</details>

## About The Project
backend-agenter service that send files in quarantine or detect if the site has file which is in quarantine

## Stack
- Golang 1.17
- PostgreSQL 14.1
- Docker 20.10.7
- Docker compose 1.29.2

## Running
The project is made using docker containers
1. Set your env in docker-compose.yml file.
2. Run to start agenter. 
```
$ docker-compose up -d --build --force-recreate --no-deps agenter
```
## Envs
```
CONFIG_FILE_PATH=
CONFIG_FILE_NAME=
CONFIG_FILE_FORMAT=
```
## Configs
```yaml
app:
  mode: 

postgres:
  protocol: 
  url: 
  port: 
  database: 
  av_objects_table: 
  urls_table: 
  username:   
  password: 
  timeout: 

transport:
  host: 
  port: 
  type: 
  name: 
  version: 
  class: 
  timeout: 
  concurrency_limit: 

agent:
  timeout: 
  full_scan: 
  is_quarantine: 
  module_name: 
```
## Image-build
Here are the steps to reproduce image building:
1. Make sure you are on the right branch. If not switch to required one.
2. Make sure that DOCKER_BUILDKIT is set in /etc/docker/daemon.json, the content of the file is next:
```json
{
  "features": {
    "buildkit": true
  }
}
```
3. Enter the command to build image:
```bash
docker build -t harbor.wtotem.net/webtotem/agenter:{tag} -f build/Dockerfile .
```
4. To push image to the registry:
```bash
docker push harbor.wtotem.net/webtotem/agenter:{tag}
```

## Deploy
1. Set all the <a href="#envs">envs</a>
2. Set all configs in <a href="#configs">configuration file</a>
3. Make sure that all <a href="#stack">technologies</a> are present in the server
4. Make sure that the whole database schema is present in the database (according to /scripts directory)
5. Make sure to pass all needed volumes
6. Up the service using need technology (docker-compose and etc.)
### Example
```yaml
  agenter:
    build:
      context: .
      dockerfile: build/Dockerfile
    container_name: agenter
    volumes:
      - ./config:/root/config
    environment:
      - CONFIG_FILE_PATH=../config
      - CONFIG_FILE_NAME=localconfig
      - CONFIG_FILE_FORMAT=yaml
    networks:
      - dev
```


## Maintainers
- Developed by @dana_veli  
- Tested by
- Analytics by @adilk
