# Backend Project Layout

### System requirements
0. Install **go**, **docker**, **docker-compose** (just google it)
    
    P.S. for **"docker"** makefile target you need set enviroment variable **DOCKER_BUILDKIT**

    ```console
    export DOCKER_BUILDKIT=1
    ```
    You can add this command in **~/.bashrc** file
1. Install **godoc**
    ```console
    # Go 1.16+
    go install golang.org/x/tools/cmd/godoc@latest
    # Go version < 1.16
    go get -u golang.org/x/tools/cmd/godoc@latest
    ```
2. Install **golangci-lint**
    ```console
    # Go 1.16+
    go install github.com/golangci/golangci-lint/cmd/golangci-lint@latest

    # Go version < 1.16
    go get -u github.com/golangci/golangci-lint/cmd/golangci-lint@latest
    ```
    or binary build (**$GOPATH/bin** must be included in **$PATH**)
    ```console
    # binary will be $(go env GOPATH)/bin/golangci-lint
    curl -sSfL https://raw.githubusercontent.com/golangci/golangci-lint/master/install.sh | sh -s -- -b $(go env GOPATH)/bin v1.43.0
    ```
3. Install **make**

    Ubuntu/Debian/Linux mint:
    ```console
    sudo apt install make
    ```

    Centos/Fedora/RHEL:
    ```console
    sudo yum install make
    ```

    Manjaro:
    ```console
    sudo pacman -S make
    ```
4. Install **pre-commit**
    ```console
    pip install pre-commit
    ```
    In your project directory run command for pre-commit installing
    ```console
    pre-commit install
    ```

### Project directories description

1. **/bin** - directory for building application binary file
2. **/build** - directory that contains Dockerfile, docker-compose file and etc.
3. **/cmd** - directory that contains source code file with main function
4. **/config** - directory that contains interface for parsing YAML configuration files
5. **/docs** - directory for documentation storing
6. **/internal** - main directory that must contains your service logic
7. **/scripts** - directory that contains initial scripts (bash, SQL and etc.)
8. **/vendor** - automatic generated directory that consist all project dependencies

### Other files

1. **Makefile** - project makefile which contains some helpful targets
2. **.gitignore** - file specifies intentionally untracked files that Git should ignore. By default contains only **"config/local.yaml"** file

### How to start development process?

* [ ] Change go mod name on yours
* [ ] Change project name in Makefile
* [ ] Enable pre-commit
* [ ] (OPTIONAL) Delete .gitignore files from **bin**, **internal**, **scripts** directories
* [ ] (OPTIONAL) Change binary name in Dockerfile (from **"prog"** to another one)
* [ ] Start coding in **internal** directory