package delivery

import (
	"backend-agenter/internal/service"

	tr "gitlab.wtotem.net/webtotem/backend-transport-client-quic"
	"go.uber.org/zap"
)

type Handler struct {
	transportClient *tr.TransportClient
	service         *service.Service
}

func New(transport *tr.TransportClient, service *service.Service) *Handler {
	return &Handler{
		transportClient: transport,
		service:         service,
	}
}

func (h *Handler) Run() error {
	if err := h.transportClient.RegisterHandler(h.getQuarantineHandler); err != nil {
		zap.S().Errorf("Error while register handler. Error: %v", err)
		return err
	}

	if err := h.transportClient.RegisterHandler(h.checkQuarantineHandler); err != nil {
		zap.S().Errorf("Error while register handler. Error: %v", err)
		return err
	}

	return h.transportClient.Run()
}

func (h *Handler) Stop() {
	h.transportClient.Stop()
}
