package delivery

import (
	"backend-agenter/internal/models"
	pbm "backend-agenter/pb"
	"errors"

	"go.uber.org/zap"
)

func (h *Handler) getQuarantineHandler(req *pbm.QuarantineInfoRequest) (*pbm.QuarantineInfoResponse, error) {
	zap.S().Info("Get quarantine handler is starting the job...")

	response := &pbm.QuarantineInfoResponse{
		ErrCode: models.StatusOK,
	}

	incomingCID := req.Cid

	files, err := h.service.QuarantineService.Get(incomingCID)
	if err != nil {
		switch {
		case errors.Is(err, models.ErrDatabase):
			response.ErrCode = models.StatusDatabaseError
			response.ErrText = models.ErrDatabase.Error()
			return response, nil

		case errors.Is(err, models.ErrConnectToHost):
			response.ErrCode = models.StatusNotAvailable
			response.ErrText = models.ErrConnectToHost.Error()
			return response, nil

		case errors.Is(err, models.ErrStartSession):
			response.ErrCode = models.StatusNotAvailable
			response.ErrText = models.ErrStartSession.Error()
			return response, nil

		case errors.Is(err, models.ErrFromAgent):
			response.ErrCode = models.StatusNotAvailable
			response.ErrText = models.ErrFromAgent.Error()
			return response, nil
		default:
			response.ErrCode = models.StatusNotAvailable
			response.ErrText = models.ErrSystem.Error()
			return response, nil
		}
	}

	zap.S().Infof("Successfully got quarantined files: %v", files)

	response.QuarantineFiles = files

	return response, nil
}
