package delivery

import (
	"backend-agenter/internal/models"
	pbm "backend-agenter/pb"
	"errors"

	"go.uber.org/zap"
)

func (h *Handler) checkQuarantineHandler(req *pbm.IsQuarantinedRequest) (*pbm.IsQuarantinedResponse, error) {
	response := &pbm.IsQuarantinedResponse{
		ErrCode:       models.StatusOK,
		IsQuarantined: false,
	}

	incomingCID := req.Cid

	IsQuarantined, err := h.service.QuarantineService.IsQuarantine(incomingCID)
	if err != nil {
		switch {
		case errors.Is(err, models.ErrDatabase):
			response.ErrCode = models.StatusDatabaseError
			response.ErrText = models.ErrDatabase.Error()
			return response, nil

		case errors.Is(err, models.ErrConnectToHost):
			response.ErrCode = models.StatusNotAvailable
			response.ErrText = models.ErrConnectToHost.Error()
			return response, nil

		case errors.Is(err, models.ErrStartSession):
			response.ErrCode = models.StatusNotAvailable
			response.ErrText = models.ErrStartSession.Error()
			return response, nil

		case errors.Is(err, models.ErrFromAgent):
			response.ErrCode = models.StatusNotAvailable
			response.ErrText = models.ErrFromAgent.Error()
			return response, nil
		default:
			response.ErrCode = models.StatusNotAvailable
			response.ErrText = models.ErrSystem.Error()
			return response, nil
		}
	}

	response.IsQuarantined = IsQuarantined

	zap.S().Infof("Successfully got result is the site has quarantined files: %v", IsQuarantined)

	return response, nil
}
