package models

type Config struct {
	Proxy        string `json:"proxy,omitempty"`
	UserID       string `json:"userID,omitempty"`
	AgentKey     string `json:"agentKey,omitempty"`
	AgentName    string `json:"agentName,omitempty"`
	PrivateKey   string `json:"privateKey,omitempty"`
	AgentVersion int    `json:"agentVersion,omitempty"`
	AvDecryptKey string `json:"avDecryptKey,omitempty"`
}

type AvObject struct {
	ObjectID int64
	Config   *Config
}

type Url struct {
	Schema string
	Host   string
	Port   uint16
	Path   string
}

type AgentQuarantineFilesResponse struct {
	Files []string `json:"files"`
}

type AgentIsQuarantineResponse struct {
	IsQuarantine bool `json:"is_quarantine"`
}

const (
	CmdGetQuarantine = "get_quarantine"
)

const (
	StatusOK            = 0
	StatusDatabaseError = 100
	StatusNotAvailable  = 500
)
