package repository

import (
	"backend-agenter/internal/config"
	"backend-agenter/internal/repository/agent"
	db "backend-agenter/internal/repository/database"
	"backend-agenter/internal/repository/database/postgres"

	"github.com/jackc/pgx/v4/pgxpool"
)

type Repository struct {
	AgentRepository agent.Agent
	AvRepository    db.Av
}

func New(db *pgxpool.Pool, config *config.Config) *Repository {
	return &Repository{
		AgentRepository: agent.New(config.Agent),
		AvRepository:    postgres.New(db, config.Postgres),
	}
}
