package repository

import (
	"backend-agenter/internal/config"

	tr "gitlab.wtotem.net/webtotem/backend-transport-client-quic"
	"go.uber.org/zap"
)

func NewTransportClient(config *config.Transport) (*tr.TransportClient, error) {
	clientInfo := &tr.ClientInfo{
		Type:    config.Type,
		Class:   config.Class,
		Name:    config.Name,
		Version: config.Version,
	}

	transport, err := tr.NewTransportClient(clientInfo, config.URL, config.Port, config.Timeout, config.ConcurrencyLimit)
	if err != nil {
		zap.S().Errorf("Could not create transport client. Error: %v", err)
		return nil, err
	}

	zap.S().Info("Successfully created transport client")

	return transport, nil
}
