package service

import (
	"backend-agenter/internal/repository"
)

type Service struct {
	QuarantineService Quarantine
}

type Quarantine interface {
	Get(cid int64) ([]string, error)
	IsQuarantine(cid int64) (bool, error)
}

func New(repository *repository.Repository) *Service {
	return &Service{
		QuarantineService: newQuarantineService(repository),
	}
}
