package config

import (
	"fmt"
	"log"
	"os"

	"github.com/joho/godotenv"
	"github.com/spf13/viper"
)

func CheckEnvs(requiredEnvs []string) error {
	for _, env := range requiredEnvs {
		value, exist := os.LookupEnv(env)
		if !exist || len(value) == 0 {
			return fmt.Errorf("required env not set: %s", env)
		}
	}

	return nil
}

func LoadEnv(path string) error {
	err := godotenv.Load(path)
	if err != nil {
		return err
	}

	return nil
}

func LoadConfig(path, fileName, fileFormat string) error {
	log.Printf("Config path: %s", path)
	viper.AddConfigPath(path)
	viper.SetConfigName(fileName)
	viper.SetConfigType(fileFormat)

	err := viper.ReadInConfig()
	if err != nil {
		return err
	}

	return nil
}
