#!/bin/bash

for d in $(find $TARGET -type d); do 
    echo "Generate doc for $PWD/$d"
    mkdir -p docs/$d
    STYLEPATH="../../"
    STYLEPATH+=$(echo $d | sed -r "s/internal//; s|(\\/[^\\/]*)|\\.\\.\\/|g")
    
    godoc -url "http://localhost:6060/pkg/$GIT/$PROJECT/$d?m=all" > docs/$d/index.html
    sed -r -i "s|\\\"(.*)\\/\\?m=all|\\\"${STYLEPATH}docs\\/$d\\/\\1\\/index.html\\?m=all|g" docs/$d/index.html
    sed -r -i "/^<link type=\"text\\/css\" rel=\"stylesheet\" href=\"\\/lib\\/godoc\\/style\\.css\">$/{
        s|^<link type=\"text\\/css\" rel=\"stylesheet\" href=\"\\/lib\\/godoc\\/style\\.css\">$||g

        a <style>
        r docs/godoc/style.css
        a </style>
    }" docs/$d/index.html

    sed -r -i "/^<script src=\"\\/lib\\/godoc\\/jquery\\.js\" defer><\\/script>$/{
        s|^<script src=\"\\/lib\\/godoc\\/jquery\\.js\" defer><\\/script>$||g

        a <script>
        r docs/godoc/jquery.js
        a </script>
    }" docs/$d/index.html

    sed -r -i "/^<script src=\"\\/lib\\/godoc\\/godocs\\.js\" defer><\\/script>$/{
        s|^<script src=\"\\/lib\\/godoc\\/godocs\\.js\" defer><\\/script>$||g

        a <script>
        r docs/godoc/godoc.js
        a </script>
    }" docs/$d/index.html

    sed -r -i "s/<a href=\"..\">..<\\/a>/<a href=\"..\\/index.html\">..<\\/a>/g" docs/$d/index.html
done
