package requestor

import (
	"time"

	parser "gitlab.wtotem.net/webtotem/backend-library-ycr"
)

var configFilename string = "config.yaml"

// config - implementation for Config interface
type config struct {
	cfg parser.Yaml
}

// Value - interface for config valur description
type Value interface {
	Bool(def bool) bool
	Int(def int) int
	String(def string) string
	Float64(def float64) float64
	Duration(def time.Duration) time.Duration
	StringSlice(def []string) []string
	StringMap(def map[string]string) map[string]string
	Bytes() []byte
}

// Config - main config interface
type Config interface {
	Get(path ...string) Value
}

// initConfig - function for creating and initializing new config instance
func initConfig() (Config, error) {
	c := &config{}
	conf := parser.NewYaml()
	c.cfg = conf

	log.Infof("config path: %s", configFilename)

	yaml := parser.NewYamlSource(configFilename)
	env := parser.NewEnvSource(parser.WithStrippedPrefix("WT"))

	sources := make([]parser.Source, 0, 2)

	sources = append(sources, yaml, env)

	err := c.cfg.Load(sources...)
	if err != nil {
		log.Errorf("[initConfig]: Error while parsing YAML file! Error: %v", err)
		return nil, err
	}
	return c, nil
}

// Get - method for geting values form config
func (c *config) Get(path ...string) Value {
	return c.cfg.Get(path...)
}
