package requestor

type LibLogger interface {
	Debugf(format string, args ...interface{})
	Debug(args ...interface{})
	Debugln(args ...interface{})

	Infof(format string, args ...interface{})
	Info(args ...interface{})
	Infoln(args ...interface{})

	Printf(format string, args ...interface{})
	Print(args ...interface{})
	Println(args ...interface{})

	Warnf(format string, args ...interface{})
	Warn(args ...interface{})
	Warnln(args ...interface{})

	Errorf(format string, args ...interface{})
	Error(args ...interface{})
	Errorln(args ...interface{})

	Fatalf(format string, args ...interface{})
	Fatal(args ...interface{})
	Fatalln(args ...interface{})
}

type loggerImplementor struct {
	enable bool
}

func (logImpl *loggerImplementor) Debugf(format string, args ...interface{}) {
	if logImpl.enable {
		log.Debugf(format, args...)
	}
}

func (logImpl *loggerImplementor) Debug(args ...interface{}) {
	if logImpl.enable {
		log.Debug(args...)
	}
}

func (logImpl *loggerImplementor) Debugln(args ...interface{}) {
	if logImpl.enable {
		log.Debugln(args...)
	}
}

func (logImpl *loggerImplementor) Infof(format string, args ...interface{}) {
	if logImpl.enable {
		log.Infof(format, args...)
	}
}

func (logImpl *loggerImplementor) Info(args ...interface{}) {
	if logImpl.enable {
		log.Info(args...)
	}
}

func (logImpl *loggerImplementor) Infoln(args ...interface{}) {
	if logImpl.enable {
		log.Infoln(args...)
	}
}

func (logImpl *loggerImplementor) Warnf(format string, args ...interface{}) {
	if logImpl.enable {
		log.Warnf(format, args...)
	}
}

func (logImpl *loggerImplementor) Warn(args ...interface{}) {
	if logImpl.enable {
		log.Warn(args...)
	}
}

func (logImpl *loggerImplementor) Warnln(args ...interface{}) {
	if logImpl.enable {
		log.Warnln(args...)
	}
}

func (logImpl *loggerImplementor) Printf(format string, args ...interface{}) {
	if logImpl.enable {
		log.Printf(format, args...)
	}
}

func (logImpl *loggerImplementor) Print(args ...interface{}) {
	if logImpl.enable {
		log.Print(args...)
	}
}

func (logImpl *loggerImplementor) Println(args ...interface{}) {
	if logImpl.enable {
		log.Println(args...)
	}
}

func (logImpl *loggerImplementor) Errorf(format string, args ...interface{}) {
	if logImpl.enable {
		log.Errorf(format, args...)
	}
}

func (logImpl *loggerImplementor) Error(args ...interface{}) {
	if logImpl.enable {
		log.Error(args...)
	}
}

func (logImpl *loggerImplementor) Errorln(args ...interface{}) {
	if logImpl.enable {
		log.Errorln(args...)
	}
}

func (logImpl *loggerImplementor) Fatalf(format string, args ...interface{}) {
	if logImpl.enable {
		log.Fatalf(format, args...)
	}
}

func (logImpl *loggerImplementor) Fatal(args ...interface{}) {
	if logImpl.enable {
		log.Fatal(args...)
	}
}

func (logImpl *loggerImplementor) Fatalln(args ...interface{}) {
	if logImpl.enable {
		log.Fatalln(args...)
	}
}

func NewLibLogger(enable bool) LibLogger {
	return &loggerImplementor{
		enable: enable,
	}
}
