package requestor

import (
	"net/http"
	liburl "net/url"
	"time"
)

type SessionOption interface {
	apply(session *AgentSessionImplementor)
}

type SessionProxyOption struct {
	URL string
}

func (proxy *SessionProxyOption) apply(session *AgentSessionImplementor) {
	url, err := liburl.Parse(proxy.URL)
	if err != nil {
		return
	}
	session.client.Transport.(*http.Transport).Proxy = http.ProxyURL(url)
}

func GetSessionProxyOption(url string) SessionOption {
	return &SessionProxyOption{URL: url}
}

type SessionLogOption struct {
	enable bool
}

func (sessionLog *SessionLogOption) apply(session *AgentSessionImplementor) {
	session.log = NewLibLogger(sessionLog.enable)
}

func GetSessionLogOption(enable bool) SessionOption {
	return &SessionLogOption{
		enable: enable,
	}
}

type SessionTimeoutOption struct {
	timeout time.Duration
}

func (sessionTimeout *SessionTimeoutOption) apply(session *AgentSessionImplementor) {
	session.SessionTimeout = sessionTimeout.timeout
}

func GetSessionTimeoutOption(duration time.Duration) SessionOption {
	return &SessionTimeoutOption{
		timeout: duration,
	}
}
