package connection

import (
	"context"

	"github.com/lucas-clemente/quic-go"
)

// FrameStreamImpl - struct for implementing FrameStream interface
type FrameStreamImpl struct {
	stream quic.Stream
}

// This function use for accepting QUIC stream
func NewIncomingStream(ctx context.Context, sess quic.Session) (FrameStream, error) {
	stream, err := sess.AcceptStream(ctx)
	if err != nil {
		return nil, err
	}

	return &FrameStreamImpl{
		stream: stream,
	}, nil
}

// This function use for creating QUIC stream
func NewOutgoingStream(ctx context.Context, sess quic.Session) (FrameStream, error) {
	stream, err := sess.OpenStreamSync(ctx)
	if err != nil {
		return nil, err
	}

	return &FrameStreamImpl{
		stream: stream,
	}, nil
}

// This function use for accepting QUIC unidirectional stream
func NewIncomingUniStream(ctx context.Context, sess quic.Session) (FrameReadStream, error) {
	stream, err := sess.AcceptUniStream(ctx)
	if err != nil {
		return nil, err
	}

	return &FrameReadStreamImpl{
		stream: stream,
	}, nil
}

// This function use for creating QUIC stream
func NewOutgoingUniStream(ctx context.Context, sess quic.Session) (FrameWriteStream, error) {
	stream, err := sess.OpenUniStreamSync(ctx)
	if err != nil {
		return nil, err
	}

	return &FrameWriteStreamImpl{
		stream: stream,
	}, nil
}
