package lexer

import "gitlab.wtotem.net/webtotem/backend-library-ycr/token"

func (lexer *Lexer) changeState(state lexState) {
	lexer.state = state
}

// return next token from channel
func (lexer *Lexer) NextToken() token.Token {
	// if we reached the end no reason to search for new token
	if lexer.Following.Mod == token.TOKEN_EOF {
		return lexer.Following
	}

	return lexer.state(lexer)
}

// put token into token channel
func (lexer *Lexer) putToken(tokenMod token.TokenMod) token.Token {
	if lexer.start >= lexer.pos {
		lexer.start = lexer.pos
	}
	if lexer.pos >= len(lexer.input) {
		lexer.pos = len(lexer.input)
	}
	t := token.Token{Mod: tokenMod, Value: lexer.input[lexer.start:lexer.pos]}
	lexer.start = lexer.pos
	return t
}
